/*
* main.cpp
*
* Created: 08/06/2014 14:12:25
*  Author: Mourad MKHAKH
*/
#define F_CPU 16000000
#include <avr/io.h>
#include <util/delay.h>

#include "LiquidCrystal.h"

static void avr_init(void)
{
	// config  the LCD
	lcd_begin();
	// config input&outputs of the module
	IOS_Inits();
	// pin  Vo  au GND, pas de PWM
	LCD_VO_Off;
}


volatile int16_t contrast = 127;
volatile int16_t backLight = 127;

int main(void)
{
	avr_init();

	//etat des buttons pour detction de falnc montant ou descendant
	uint8_t  OldEnter = false;
	uint8_t  OldInc = false;
	uint8_t  OldDec = false;
	uint8_t  OldUp = false;
	uint8_t  OldDown = false;
	uint8_t  OldEsc = false;

	for (;;)
	{
		// bouton Enter
		if (EnterOn  && !OldEnter) {
			lcd_clear();	// efface la totalit de la LCD
			lcd_setCursor(0,0);
			lcd_printChar(97);	lcd_printChar(97 +1 );	 lcd_printChar(97 +2);	lcd_printChar(97 +3);	//  affiche 'abcd'
			lcd_setCursor(0,1);
			lcd_printuInt((uint16_t)(-1),HEX); // affiche un FFFF
			lcd_setCursor(0,2);
			lcd_printInt(-128,DEC); //affiche -128
			lcd_setCursor(0,3);
			lcd_printHex(-1234,DDWORD); //Affiche 0xFFFFFB2E
		}
		
		// bouton Inc: incremente la lumier Led d'arriere plant LCD en PWM sur TIMER2
		if (IncOn  && !OldInc) {
			backLight += 16;
			if (backLight & 0xFF00)
			{
				backLight = 0xFF;
			}
			OCR2A = backLight;
		}

		// bouton Dec : decremente la lumier Led d'arriere plant LCD en PWM sur TIMER2
		if (DecOn  && !OldDec) {
			backLight -= 16;
			if (backLight < 0)
			{
				backLight = 1;
			}
			OCR2A = backLight;
		}
		// bouton Up : incremente le contrast LCD en PWM sur TIMER0
		if (UpOn  && !OldUp) {
			contrast += 16;
			if (contrast & 0xFF00)
			{
				contrast = 0xFF;
			}
			OCR0A = contrast;
		}

		// bouton Down : decremente le contrast LCD en PWM sur TIMER0
		if (DownOn  && !OldDown){
			contrast -= 16;
			if (contrast < 0)
			{
				contrast = 1;
			}
			OCR0A = contrast;
		}

		// bouton Esc: faire une routine de test d'affichage LCD
		if (EscOn && !OldEsc) {
			cli();
			lcd_selfTest();
			sei();
			lcd_clear();
		}

		// memorise l'etat des buttons
		OldEnter = EnterOn;
		OldInc = IncOn;
		OldDec = DecOn;
		OldUp = UpOn;
		OldDown = DownOn;
		OldEsc = EscOn;
		// un delay pour l'antirebond
		_delay_ms(50);
	}
}
